package w83b.w83bManager;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bDAO.w83bConstantesBD.W83bPreavisosBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;

public class W83bPreavisos implements W83bIPreavisos{

	public java.util.List buscarPreavisos(w83b.w83bBeans.W83bPreavisosBean param) throws Exception{
		
		
		List listaPreavisos = W83bFactoriaDAO.getPreavisosDAO().buscarPreavisos(param);
		W83bPreavisosBean bean; 
		HashMap provincias=new HashMap();
		HashMap municipios=new HashMap();
		String provincia="";
		String municipio="";
//		long tiempo=System.currentTimeMillis();
		for(int i=0,size=listaPreavisos.size();i<size;i++){
			bean = (W83bPreavisosBean)listaPreavisos.get(i);
			if (municipios.get(bean.getCentroTrabajo().getTerritorio()+"|"+bean.getCentroTrabajo().getMunicipio())!=null){
				bean.getCentroTrabajo().setMunicipio((String)municipios.get(bean.getCentroTrabajo().getTerritorio()+"|"+bean.getCentroTrabajo().getMunicipio()));
			}
			else{
				municipio=W83bFactoriaDAO.getActasDAO().obtenerMunicipio(bean.getCentroTrabajo().getTerritorio(),bean.getCentroTrabajo().getMunicipio());
				municipios.put(bean.getCentroTrabajo().getTerritorio()+"|"+bean.getCentroTrabajo().getMunicipio(),municipio);
				bean.getCentroTrabajo().setMunicipio(municipio);
				
			}
			if (provincias.get(bean.getCentroTrabajo().getTerritorio())!=null){
				bean.getCentroTrabajo().setTerritorio((String)provincias.get(bean.getCentroTrabajo().getTerritorio()));
			}
			else{
				provincia=W83bFactoriaDAO.getActasDAO().obtenerTerritorio(bean.getCentroTrabajo().getTerritorio());
				provincias.put(bean.getCentroTrabajo().getTerritorio(), provincia);
				bean.getCentroTrabajo().setTerritorio(provincia);
			}
			/*if (i%1000==0){
				System.out.println(i+"tamao"+size+" tiempo="+String.valueOf(System.currentTimeMillis()-tiempo)+" "+provincias+" "+municipios);
			}*/
			
		}
		
		return listaPreavisos;	
	}

	
	public String adjuntarArchivoPreavisos(HashMap param) throws Exception {
		 return W83bFactoriaDAO.getPreavisosDAO().adjuntarArchivoPreavisos(param);
	}
	
	public HashMap calcularNumPreaviso(W83bPreavisosBean param) throws Exception {
		HashMap res=new HashMap();
		String resultado = "0";
		String fechaRegistro="";
		if(StringUtils.isEmpty(param.getNum_preaviso())){
			String maxPreaviso = W83bFactoriaDAO.getPreavisosDAO().maxCodPreavisos(param);
			if(W83bPreavisosBD.maxNumPreaviso.equals(maxPreaviso)){
				boolean codEncontrado = false;
				if(Integer.parseInt(maxPreaviso)+1
						!=Integer.parseInt(W83bFactoriaDAO.getPreavisosDAO().contarPreavisos(param))){
					while(!codEncontrado){
						maxPreaviso = String.valueOf(Integer.parseInt(maxPreaviso)-1);//NOPMD
						codEncontrado = !W83bFactoriaDAO.getPreavisosDAO().existePreaviso(param,maxPreaviso);
					}
					int tamanyo = maxPreaviso.length();
					for(int i=tamanyo;i<6;i++){
						maxPreaviso = "0"+maxPreaviso;//NOPMD
					}
					param.setNum_preaviso(maxPreaviso);
					resultado = param.getNum_preaviso();
//					fechaRegistro=W83bFactoriaDAO.getPreavisosDAO().anyadirPreavisos(param);	
					res.put("numPreaviso", resultado);
					res.put("fechaRegistro", fechaRegistro);
				}else{
					resultado = "-1";
					res.put("numPreaviso", resultado);
					res.put("fechaRegistro", fechaRegistro);
					return res;
				}
			}else{				
				maxPreaviso = String.valueOf(Integer.parseInt(maxPreaviso)+1);//NOPMD
				int tamanyo = maxPreaviso.length();
				for(int i=tamanyo;i<6;i++){
					maxPreaviso = "0"+maxPreaviso;//NOPMD
				}
				param.setNum_preaviso(maxPreaviso);		
				resultado = maxPreaviso;
//				fechaRegistro=W83bFactoriaDAO.getPreavisosDAO().anyadirPreavisos(param);	
				res.put("numPreaviso", resultado);
				res.put("fechaRegistro", fechaRegistro);
			}
		}else {
			if(!W83bFactoriaDAO.getPreavisosDAO().existePreaviso(param,param.getNum_preaviso())){
				int tamanyo = param.getNum_preaviso().length();
				for(int i=tamanyo;i<6;i++){
					param.setNum_preaviso("0"+param.getNum_preaviso());
				}
//				fechaRegistro=W83bFactoriaDAO.getPreavisosDAO().anyadirPreavisos(param);	
				resultado = param.getNum_preaviso();
				res.put("numPreaviso", resultado);
				res.put("fechaRegistro", fechaRegistro);
			}else{
				resultado = "-2";				
				res.put("numPreaviso", resultado);
				res.put("fechaRegistro", fechaRegistro);
			}
		}	
		return res;
	}

	public HashMap anyadirPreavisos(W83bPreavisosBean param) throws Exception {
		
//		String fechaRegistro = "";
//		String resultado = "";
		
//		HashMap res = calcularNumPreaviso(param);
		
		HashMap res = W83bFactoriaDAO.getPreavisosDAO().anyadirPreavisos(param);		
//		resultado = (String)res.get("numPreaviso") ;
//		res.put("numPreaviso", resultado);
//		res.put("fechaRegistro", fechaRegistro);
		return res;
	}
	
	public void insertarDocsPreavisos(W83bPreavisosBean param) throws Exception {
		W83bFactoriaDAO.getPreavisosDAO().insertarDocsPreavisos(param);
	}
	
	public void anyadirPromotores(W83bPreavisosBean param) throws Exception {
		W83bFactoriaDAO.getPreavisosDAO().anyadirPromotores(param);
	}
	
	public void anyadirHistorialTramitacion(W83bPreavisosBean param,String fase, String tramite,String fechaRegistro) throws Exception {
		W83bFactoriaDAO.getPreavisosDAO().anyadirHistorialTramitacion(param,W83bClsConstantes.FASE_TRAMITACION_PREAVISO,W83bClsConstantes.TRAMITE_RECEPCION_PREAVISO_E_INICIACION_EXPED,fechaRegistro);
		if(null!=param.getListaDocs()){			
			for (int i=0;i<param.getListaDocs().size();i++){
				W83bDocBean doc=(W83bDocBean)param.getListaDocs().get(i);
				if(!W83bClsConstantes.TRAMITE_SINESPECIFICAR.equals(doc.getCodTramite())){
					if(W83bFactoriaDAO.getPreavisosDAO().existeTramite(param,Integer.parseInt(doc.getCodFase()),
							Integer.parseInt(doc.getCodTramite()))){
						W83bFactoriaDAO.getPreavisosDAO().editarTramite(param, 
								Integer.parseInt(doc.getCodFase()), Integer.parseInt(doc.getCodTramite()));
					}
					else{
						W83bFactoriaDAO.getPreavisosDAO().anyadirHistorialTramitacion(param,doc.getCodFase(),doc.getCodTramite(),fechaRegistro);
					}
				}
			}
		}
	}
	
	public void insertarPreavisoOriginal(W83bPreavisosBean param) throws Exception {
		W83bFactoriaDAO.getPreavisosDAO().insertarPreavisoOriginal(param);
	}

	public String edicionPreavisos(W83bPreavisosBean param) throws Exception {
			
			W83bFactoriaDAO.getPreavisosDAO().editarPreavisos(param);	
			W83bFactoriaDAO.getPreavisosDAO().borrarPromotoresPreavisos(param);
			if(null!=param.getListaDocs()){
				
				for (int i=0;i<param.getListaDocs().size();i++){
					W83bDocBean doc=(W83bDocBean)param.getListaDocs().get(i);
					if(!W83bClsConstantes.TRAMITE_SINESPECIFICAR.equals(doc.getCodTramite())){
						if(W83bFactoriaDAO.getPreavisosDAO().existeTramite(param,Integer.parseInt(doc.getCodFase()),
								Integer.parseInt(doc.getCodTramite()))){
							W83bFactoriaDAO.getPreavisosDAO().editarTramite(param, 
									Integer.parseInt(doc.getCodFase()), Integer.parseInt(doc.getCodTramite()));
						}
						else{
							W83bFactoriaDAO.getPreavisosDAO().anyadirHistorialTramitacion(param,doc.getCodFase(),doc.getCodTramite(),param.getFecha_registro());
						}
					}
				}
			}
			
			W83bFactoriaDAO.getPreavisosDAO().anyadirPromotores(param);
			String errorLibroRegistro = "";
			String error =	W83bFactoriaDAO.getPreavisosDAO().insertarDocsPreavisos(param);
			
			if("true".equals(error)){
				errorLibroRegistro = "-3";
			}
			
			W83bFactoriaDAO.getPreavisosDAO().borrarDocsPreavisos(param);
			
			//comento esto xq no es posible modificar el preaviso original
			if (StringUtils.isNotEmpty(param.getPreavisoOriginalBean().getActualizado()))
			{
				param.getPreavisoOriginalBean().setIdioma(param.getIdioma());
				param.getPreavisoOriginalBean().setUsuarioBean(param.getUsuarioBean());
				param.getPreavisoOriginalBean().setCodSelec(param.getCodSelec());
				param.getPreavisoOriginalBean().setNum_preaviso(param.getNum_preaviso());
				param.getPreavisoOriginalBean().setAnyoPreaviso(param.getAnyoPreaviso());
				param.getPreavisoOriginalBean().setCodTerritorio(param.getCodTerritorio());
				W83bFactoriaDAO.getPreavisosDAO().editarPreavisosOriginal(param.getPreavisoOriginalBean());	
				W83bFactoriaDAO.getPreavisosDAO().borrarPromotoresPreavisosOriginal(param.getPreavisoOriginalBean());
				W83bFactoriaDAO.getPreavisosDAO().anyadirPromotoresOriginal(param.getPreavisoOriginalBean());

			}
			
		
			return param.getCodSelec()+errorLibroRegistro;
	}
	

	public String borrarPreavisos(List param) throws Exception {
		boolean borrado = true;
		
		W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)param.get(param.size()-1);
		param.remove(param.size()-1);
		
		for(int i=0,size=param.size();i<size;i++){
			borrado =  W83bFactoriaDAO.getPreavisosDAO().borrarPromotoresPreavisoOriginal((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getPreavisosDAO().borrarPreavisoOriginal((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getPreavisosDAO().borrarDocsPreaviso((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getPreavisosDAO().borrarPromotores((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getPreavisosDAO().borrarHistorial((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getPreavisosDAO().borrarHistorialTramitacionPreaviso((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getPreavisosDAO().borrarPreaviso((String)param.get(i),userBean);
			
			if(!borrado){
				break;
			}
		}
		if (borrado)
			return "success";
		else 
			throw new Exception();//NOPMD
	}

	public W83bPreavisosBean obtenerDetallesPreaviso(HashMap param)
			throws Exception {
		
		String pestania=(String)param.get("pestania");
		if ("0".equals(pestania))
		{
			//datos basicos
			W83bFactoriaDAO.getPreavisosDAO().insertarHistorialTramitacion((String)param.get("codSelec"),((W83bUsuarioXLNetsBean)param.get("user")).getIdUsuario().toUpperCase());
			W83bPreavisosBean beanPreaviso = W83bFactoriaDAO.getPreavisosDAO().obtenerDatosBasicosPreaviso((String)param.get("codSelec"),(String)param.get("strIdioma"));			
			
			String provincia=W83bFactoriaDAO.getActasDAO().obtenerTerritorio(beanPreaviso.getCentroTrabajo().getCodTerritorio());
			String municipio=W83bFactoriaDAO.getActasDAO().obtenerMunicipio(beanPreaviso.getCentroTrabajo().getCodTerritorio(),beanPreaviso.getCentroTrabajo().getCodMunicipio());
			
			beanPreaviso.getCentroTrabajo().setTerritorio(provincia);
			beanPreaviso.getCentroTrabajo().setMunicipio(municipio);
			
			beanPreaviso = W83bFactoriaDAO.getPreavisosDAO().obtenerRegDefinitivoActaPreaviso(beanPreaviso);
			return beanPreaviso;

		}
		else
			if ("1".equals(pestania))
			{
				//Preaviso original
				return W83bFactoriaDAO.getPreavisosDAO().obtenerPreavisoOriginal((String)param.get("codSelec"),(String)param.get("strIdioma"));
			}
			else
				if ("2".equals(pestania))
				{
					//Docs adjuntos
					return W83bFactoriaDAO.getPreavisosDAO().obtenerDocsPreaviso((String)param.get("codSelec"),(String)param.get("strIdioma"));
				}
				else
					if ("3".equals(pestania))
					{
						//Impugnaciones y laudos
						return W83bFactoriaDAO.getPreavisosDAO().obtenerImpugnacionesPreaviso((String)param.get("codSelec"),(String)param.get("sidx"),(String)param.get("sord"),(String)param.get("strIdioma"));
					}
					else
						if ("4".equals(pestania))
						{
							if ("1".equals(param.get("grid")))
							{
								//Historial
								return W83bFactoriaDAO.getPreavisosDAO().obtenerHistorialPreaviso((String)param.get("codSelec"),(String)param.get("sidx"),(String)param.get("sord"),(String)param.get("strIdioma"));								
							}
							else
							{
								//Tramites
								return W83bFactoriaDAO.getPreavisosDAO().obtenerTramitesPreaviso((String)param.get("codSelec"),(String)param.get("strIdioma"),(String)param.get("sidx"),(String)param.get("sord"),(String)param.get("strIdioma"));
							}

						}
		return null;
	}

	public W83bDocBean descargarDocumento(String param) throws Exception {

		return W83bFactoriaDAO.getPreavisosDAO().descargarDocumento(param);
	}


	public java.util.List cargaTiposDocumento(HashMap param) throws Exception {
		// TODO Auto-generated method stub
		return W83bFactoriaDAO.getPreavisosDAO().cargaTiposDocumento(param);
	}
	
	public java.util.List comprobarNPreaviso (java.util.HashMap param) throws Exception{
		// TODO Auto-generated method stub
		W83bPreavisosBean preaviso = new W83bPreavisosBean();
		preaviso.setAnyoPreaviso((String)param.get("anyoPreaviso"));
		preaviso.setCodTerritorio((String)param.get("territorioPreaviso"));

		List resultado = new ArrayList();
				
		if(W83bFactoriaDAO.getPreavisosDAO().existePreaviso(preaviso,(String)param.get("nPreaviso"))){
			resultado.add("true");
		}else{
			resultado.add("false");			
		}
		
		return resultado;
	}
	
	public java.util.List existeCentroPreaviso (java.util.HashMap param) throws Exception{
		// TODO Auto-generated method stub
		
		List resultado = new ArrayList();
		
		if(W83bFactoriaDAO.getPreavisosDAO().existeCentroPreaviso((String)param.get("idCentroTrabajo"),
				(String)param.get("territorioPreaviso"),
				(String)param.get("anyoPreaviso"),
				(String)param.get("nPreaviso"))){
			resultado.add("true");
		}else{
			resultado.add("false");			
		}
		
		return resultado;
	}
	
	public java.util.List existeOtroCentroPreavisoSinFechaEleccion (java.util.HashMap param) throws Exception{
		// TODO Auto-generated method stub
		
		List resultado = new ArrayList();
		
		if(W83bFactoriaDAO.getPreavisosDAO().existeOtroCentroPreavisoSinFechaEleccion(
				(String)param.get("idCentroTrabajo"),
				(String)param.get("territorioPreaviso"),(String)param.get("anyoPreaviso"),(String)param.get("nPreaviso"))){
			resultado.add("true");
		}else{
			resultado.add("false");			
		}
		
		return resultado;
	}
	
	public java.util.List validarIntervaloEleccionSindicalCtoTrabajo (java.util.HashMap param) throws Exception{
		// TODO Auto-generated method stub
		
		List resultado = new ArrayList();
		
		resultado = W83bFactoriaDAO.getPreavisosDAO().validarIntervaloEleccionSindicalCtoTrabajo(
				(String)param.get("idCentroTrabajo"),(String)param.get("idioma"),
				(String)param.get("territorioPreaviso"),(String)param.get("anyoPreaviso"),(String)param.get("nPreaviso"));
		
		if(null!=resultado 
				&&0<resultado.size()
				&&StringUtils.isNotEmpty((String)resultado.get(0))){
			String fechaEntradaQuery = (String)resultado.get(0);
			String fechaEntrada = (String)param.get("fecha_entrada");
			
			Date fechaEntradaQueryDate = W83bDateUtil.getInstance().getDate(fechaEntradaQuery,W83bDateUtil.getInstance().devolverFormatoIdioma((String)param.get("idioma")));
			Date fechaEntradaDate = W83bDateUtil.getInstance().getDate(fechaEntrada,W83bDateUtil.getInstance().devolverFormatoIdioma((String)param.get("idioma")));
			
			fechaEntradaQueryDate = W83bDateUtil.getInstance().addYears(fechaEntradaQueryDate,4);
			fechaEntradaDate = W83bDateUtil.getInstance().addMonths(fechaEntradaDate,3);
			
			resultado = new ArrayList();
			if(fechaEntradaDate.compareTo(fechaEntradaQueryDate)>=0){
				resultado.add("true");				
			}else{
				resultado.add("false");				
			}
			
		}else{
			resultado = new ArrayList();
			resultado.add("true");
		}
		
		return resultado;
	}
	
	/**
    * Actualiza la informacin de acuse de recibo de una lista de comunicaciones de preavisos
    * @param listaComunicacionesAcuse List
    * @throws Exception the exception
    */
	public void actualizarDatosAcusesComunicacionPreavisos (ArrayList listaComunicacionesAcuse)throws Exception{
		
		//Recorremos las comunicaciones
		for (Iterator iter = listaComunicacionesAcuse.iterator(); iter.hasNext();) {
			W83bDocBean docBean = (W83bDocBean) iter.next();
			docBean.setCodTramite("3");
			docBean.setCodFase("1");
			W83bFactoriaDAO.getPreavisosDAO().actualizarDatosAcuseComunicacion(docBean);
		}
		
	}
	
	
}
